<?php
// Bot poll untuk ambil unprocessed webhooks
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$queueFile = __DIR__ . '/webhook_queue.json';

if (!file_exists($queueFile)) {
    echo json_encode(['success' => true, 'webhooks' => []]);
    exit;
}

$queue = json_decode(file_get_contents($queueFile), true);
if (!is_array($queue)) {
    echo json_encode(['success' => true, 'webhooks' => []]);
    exit;
}

// Get unprocessed webhooks
$unprocessed = [];
foreach ($queue as $id => $webhook) {
    if (!$webhook['processed']) {
        $unprocessed[] = $webhook;
    }
}

echo json_encode([
    'success' => true,
    'count' => count($unprocessed),
    'webhooks' => $unprocessed
]);
?>