<?php
// Mark webhook as processed
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$queueFile = __DIR__ . '/webhook_queue.json';
$logFile = __DIR__ . '/qiospay_webhook.log';

// Get request
$input = json_decode(file_get_contents('php://input'), true);
$webhookId = $input['webhook_id'] ?? null;

if (!$webhookId) {
    echo json_encode(['success' => false, 'message' => 'Missing webhook_id']);
    exit;
}

if (!file_exists($queueFile)) {
    echo json_encode(['success' => false, 'message' => 'Queue not found']);
    exit;
}

// Load queue
$queue = json_decode(file_get_contents($queueFile), true);

// Mark as processed
if (isset($queue[$webhookId])) {
    $queue[$webhookId]['processed'] = true;
    $queue[$webhookId]['processed_at'] = date('Y-m-d H:i:s');
    
    // Save
    file_put_contents($queueFile, json_encode($queue, JSON_PRETTY_PRINT));
    
    // Log
    file_put_contents($logFile, 
        "[" . date('Y-m-d H:i:s') . "] Marked as processed: $webhookId\n", 
        FILE_APPEND
    );
    
    echo json_encode(['success' => true, 'message' => 'Marked as processed']);
} else {
    echo json_encode(['success' => false, 'message' => 'Webhook not found']);
}
?>