<?php
header('Content-Type: application/json');

$queueFile = __DIR__ . '/webhook_queue.json';
$logFile = __DIR__ . '/qiospay_webhook.log';
$timestamp = date('Y-m-d H:i:s');

// Get webhook data
$rawData = file_get_contents('php://input');
$webhookResponse = json_decode($rawData, true);

// Log incoming webhook
file_put_contents($logFile, 
    "[$timestamp] ===== WEBHOOK RECEIVED =====\n" . 
    "Raw: $rawData\n" .
    "Parsed: " . print_r($webhookResponse, true) . "\n\n", 
    FILE_APPEND
);

// ✅ CRITICAL FIX: Extract data from nested structure
$webhookData = [];

if (is_array($webhookResponse)) {
    // QiosPay sends data in nested format: {status: "success", data: {...}}
    if (isset($webhookResponse['data']) && is_array($webhookResponse['data'])) {
        $webhookData = $webhookResponse['data'];
    } else {
        // Fallback: use entire response
        $webhookData = $webhookResponse;
    }
}

// Log extracted data
file_put_contents($logFile, 
    "[$timestamp] EXTRACTED DATA:\n" . 
    print_r($webhookData, true) . "\n\n", 
    FILE_APPEND
);

// Load queue
$queue = [];
if (file_exists($queueFile)) {
    $queueContent = file_get_contents($queueFile);
    $queue = json_decode($queueContent, true);
    if (!is_array($queue)) {
        $queue = [];
    }
}

// Add to queue
$webhookId = uniqid('wh_', true);
$queue[$webhookId] = [
    'id' => $webhookId,
    'data' => $webhookData, // ✅ Now contains: amount, type, etc
    'timestamp' => $timestamp,
    'processed' => false
];

// Save queue
file_put_contents($queueFile, json_encode($queue, JSON_PRETTY_PRINT));

// Log saved
file_put_contents($logFile, 
    "[$timestamp] Saved to queue: $webhookId\n" .
    "Amount: " . ($webhookData['amount'] ?? 'N/A') . "\n" .
    "Type: " . ($webhookData['type'] ?? 'N/A') . "\n\n", 
    FILE_APPEND
);

// Respond to QiosPay
echo json_encode([
    'success' => true,
    'message' => 'Webhook received and queued',
    'webhook_id' => $webhookId,
    'amount' => $webhookData['amount'] ?? null,
    'type' => $webhookData['type'] ?? null
]);
?>